<?php
/*
Plugin Name: Nur Custom Post Types and Shortcodes
Description: This plugin adds custom post types and shortcodes used by Nur WP Theme.
Version: 1.6.10
Text Domain: nur-plugin
Domain Path: /languages/
License: GPLv2
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'NUR_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'NUR_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );

/**
 * Plugin activation
 */
function nur_plugin_install() {
	nur_cpt_register_post_types();
	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'nur_plugin_install' );

/**
 * Plugin deactivation
 */
function nur_plugin_uninstall() {
	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'nur_plugin_uninstall' );

/**
 * Load the plugin textdomain to allow localization
 */
function nur_plugin_load_text_domain() {
	load_plugin_textdomain( 'nur-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'nur_plugin_load_text_domain' );

/**
 * Custom post types
 */
require NUR_PLUGIN_DIR_PATH . 'custom-post-types.php';

/**
 * Visual Composer Add-on
 */
require NUR_PLUGIN_DIR_PATH . 'visual-composer/vc-addon.php';
