<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $content
 * @var $layout
 * @var $image_id
 * @var $image_size
 * @var $button_text
 * @var $button_href
 * @var $button_class
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$box_class = 'cta-box';
$box_class .= implode( '', array_map( function( $mod ) {
	return ' cta-box--' . $mod;
}, explode( ' ', $layout ) ) );

$box_class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$box_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $box_class, $this->settings['base'], $atts );

$image_style = '';
if ( $image_id ) {
	if ( preg_match_all( '/(\d+)x(\d+)/', $image_size, $sizes ) && isset( $sizes[1][0] ) ) {
		$image_size = array( $sizes[1][0], $sizes[2][0] );
		$image_width = $sizes[1][0];
		$image_height = $sizes[2][0];
	} else {
		$image_downsize = image_downsize( $image_id, $image_size );
		if ( ! $image_downsize ) {
			$image_size = 'medium';
			$image_downsize = image_downsize( $image_id, $image_size );
		}

		$image_width = $image_downsize[1];
		$image_height = $image_downsize[2];
	}

	$image_style .= 'width:' . $image_width . 'px;';
	$image_style .= 'height:' . $image_height . 'px;';
}

?>

<div class="<?php echo esc_attr( $box_class ); ?>">

	<?php if ( $image_id ) : ?>
		<div class="cta-box-image" style="<?php echo esc_attr( $image_style ); ?>">
			<?php echo wp_get_attachment_image( $image_id, $image_size ); ?>
		</div>
	<?php endif; ?>

	<div class="cta-box-copy">
		<?php echo wpb_js_remove_wpautop( $content, true ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

	<div class="cta-box-button">
		<a class="btn <?php echo esc_attr( $button_class ); ?>" href="<?php echo esc_url( $button_href ); ?>"><?php echo esc_html( $button_text ); ?></a>
	</div>

</div>
