<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Feature_Box' ) ) {
	class WPBakeryShortCode_Nur_Feature_Box extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_feature_box',
	'name'          => __( 'Feature Box', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_feature_box/template.php',

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'icon_font',
			'heading'    => __( 'Select icon library', 'nur-plugin' ),
			'value'      => array(
				__( 'No Icon', 'nur-plugin' )      => 'no',
				__( 'Entypo', 'nur-plugin' )       => 'entypo',
				__( 'Font Awesome', 'nur-plugin' ) => 'fontawesome',
				__( 'Linecons', 'nur-plugin' )     => 'linecons',
				__( 'Mono Social', 'nur-plugin' )  => 'monosocial',
				__( 'Open Iconic', 'nur-plugin' )  => 'openiconic',
				__( 'Themify', 'nur-plugin' )      => 'themify',
				__( 'Typicons', 'nur-plugin' )     => 'typicons',
			),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_fontawesome',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'fa fa-adjust',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'fontawesome' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'fontawesome' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_openiconic',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'vc-oi vc-oi-dial',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'openiconic' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'openiconic' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_typicons',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'typcn typcn-adjust-brightness',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'typicons' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'typicons' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_entypo',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'entypo-icon entypo-icon-note',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'entypo' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'entypo' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_linecons',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'vc_li vc_li-heart',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'linecons' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'linecons' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_monosocial',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'vc-mono vc-mono-fivehundredpx',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'monosocial' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'monosocial' ),
		),
		array(
			'type'       => 'iconpicker',
			'param_name' => 'icon_themify',
			'heading'    => __( 'Select an icon', 'nur-plugin' ),
			'value'      => 'ti-pencil',
			'settings'   => array( 'emptyIcon' => false, 'iconsPerPage' => 4000, 'type' => 'themify' ),
			'dependency' => array( 'element' => 'icon_font', 'value' => 'themify' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'layout',
			'heading'    => __( 'Select layout style', 'nur-plugin' ),
			'value'      => array(
				__( 'Style #1: Compact icon', 'nur-plugin' ) => 'small-icon',
				__( 'Style #2: Large icon', 'nur-plugin' ) => 'large-icon',
				__( 'Style #3: Large icon in circle', 'nur-plugin' ) => 'large-icon icon-circle',
				__( 'Style #4: Icon on background', 'nur-plugin' ) => 'bg-icon',
			),
		),
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'heading'    => __( 'Text content', 'nur-plugin' ),
			'holder'     => 'div',
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'colorpicker',
			'param_name' => 'icon_color',
			'heading'    => __( 'Icon Color', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
