<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $icon_font
 * @var $layout
 * @var $content
 * @var $el_class
 * @var $icon_color
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$box_class = 'feature-box';
$box_class .= implode( '', array_map( function( $mod ) {
	return ' feature-box--' . $mod;
}, explode( ' ', $layout ) ) );

$box_class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$box_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $box_class, $this->settings['base'], $atts );

$icon_class = '';
if ( 'no' !== $icon_font ) {
	vc_icon_element_fonts_enqueue( $icon_font );
	$icon_class = isset( ${'icon_' . $icon_font} ) ? ${'icon_' . $icon_font} : '';
}

$icon_style = '';
if ( $icon_color ) {
	$icon_style .= 'color:' . $icon_color . ';';
}

?>

<div class="<?php echo esc_attr( $box_class ); ?>">

	<?php if ( $icon_class ) : ?>
		<div class="feature-box-icon">
			<span class="<?php echo esc_attr( $icon_class ); ?>" <?php if ( $icon_style ) { echo 'style="' . esc_attr( $icon_style ) . '"'; } ?>></span>
		</div>
	<?php endif; ?>

	<div class="feature-box-copy">
		<?php echo wpb_js_remove_wpautop( $content, true ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

</div>
