<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $image_ids
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'logo-box';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

?>

<div class="<?php echo esc_attr( $class ); ?>">

	<?php
	foreach ( explode( ',', $image_ids ) as $image_id ) :
		$item_class = 'logo-box-item';
		$image_size = 'nur_logo';
		if ( nur_vc_is_image_wide( $image_id ) ) {
			$item_class .= ' logo-box-item--wide';
			$image_size = 'nur_logo_wide';
		}
		?>

		<div class="<?php echo esc_attr( $item_class ); ?>">
			<?php echo wp_get_attachment_image( $image_id, $image_size ); ?>
		</div>

	<?php endforeach; ?>

</div>
