<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$query = new WP_Query( array(
	'post_type'      => 'post',
	'posts_per_page' => 3,
) );

$container_class = 'recent-posts';
$container_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$container_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $container_class, $this->settings['base'], $atts );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'nur-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Posts to show here.', 'nur-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $container_class ); ?>">

		<?php while ( $query->have_posts() ) : $query->the_post(); ?>

			<div class="post-card">
				<a href="<?php the_permalink(); ?>" rel="bookmark">
					<div class="post-card-image"><?php the_post_thumbnail( 'nur_small' ); ?></div>
					<h4 class="post-card-title"><?php the_title(); ?></h4>
					<time class="post-card-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo esc_html( get_the_date() ); ?></time>
				</a>
			</div>

		<?php endwhile; ?>

		<?php wp_reset_postdata(); ?>

	</div>

<?php endif; ?>
