<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $posts_per_page
 * @var $service_tag
 * @var $dots_nav
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'all' === strtolower( $posts_per_page ) ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
) );

$carousel_class = 'services-carousel';
$carousel_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$carousel_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $carousel_class, $this->settings['base'], $atts );

$flickity_options = array(
	'cellAlign'       => 'left',
	'percentPosition' => false,
	'wrapAround'      => true,
	'rightToLeft'     => is_rtl(),
);

if ( 'hide' === $dots_nav ) {
	$flickity_options['pageDots'] = false;
	$carousel_class .= ' services-carousel--no-dots';
}

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'nur-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services to show here.', 'nur-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $carousel_class ); ?>">

		<div class="services-carousel-inner" data-flickity="<?php echo esc_attr( wp_json_encode( $flickity_options ) ); ?>">

			<?php while ( $query->have_posts() ) : $query->the_post(); ?>

				<div class="services-carousel-cell">

					<div class="service-card">
						<a href="<?php the_permalink(); ?>" rel="bookmark">
							<div class="service-card-image"><?php the_post_thumbnail( 'nur_small' ); ?></div>
							<h4 class="service-card-title"><?php the_title(); ?></h4>
						</a>
					</div>

				</div>

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div>

	</div>

<?php endif; ?>
