<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Services_Grid' ) ) {
	class WPBakeryShortCode_Nur_Services_Grid extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_services_grid',
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_services_grid/template.php',
	'name'          => __( 'Services Grid', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'service_tag',
			'heading'    => __( 'Only show items tagged in', 'nur-plugin' ),
			'value'      => nur_vc_get_taxonomy_terms( 'service_tag', array( 'All' => '' ) ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 'All',
			'heading'     => __( 'Number of items to show', 'nur-plugin' ),
			'description' => __( 'To show all items enter: All', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'show_category_filter',
			'heading'    => __( 'Show Filter by Category?', 'nur-plugin' ),
			'value'      => array(
				__( 'Hide', 'nur-plugin' ) => 'no',
				__( 'Show', 'nur-plugin' ) => 'yes',
			),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'default_filter_text',
			'value'      => __( 'All', 'nur-plugin' ),
			'heading'    => __( 'Default filter title', 'nur-plugin' ),
			'dependency' => array( 'element' => 'show_category_filter', 'value' => 'yes' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
