<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_CTA_Box' ) ) {
	class WPBakeryShortCode_Nur_CTA_Box extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_cta_box',
	'name'          => __( 'Call to Action Box', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_cta_box/template.php',

	'params'        => array(
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text content', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'layout',
			'heading'    => __( 'Select layout style', 'nur-plugin' ),
			'value'      => array(
				__( 'Style #1: Standard vertical', 'nur-plugin' )     => 'vertical',
				__( 'Style #2: Standard horizontal', 'nur-plugin' )   => 'horizontal',
				__( 'Style #3: Horizontal with image', 'nur-plugin' ) => 'horizontal image-middle',
			),
		),
		array(
			'type'       => 'attach_image',
			'param_name' => 'image_id',
			'heading'    => __( 'Image', 'nur-plugin' ),
			'dependency' => array(
				'element' => 'layout',
				'value'   => array( 'horizontal image-middle' ),
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'image_size',
			'heading'     => __( 'Image size', 'nur-plugin' ),
			'description' => __( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height).', 'nur-plugin' ),
			'value'       => 'medium',
			'dependency'  => array(
				'element' => 'layout',
				'value'   => array( 'horizontal image-middle' ),
			),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_text',
			'heading'    => __( 'Button Text', 'nur-plugin' ),
			'value'      => __( 'Button', 'nur-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_href',
			'heading'    => __( 'Button Link', 'nur-plugin' ),
			'value'      => '#',
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_class',
			'heading'    => __( 'Button CSS classes', 'nur-plugin' ),
			'value'      => 'btn-primary btn-large',
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
