<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Image_Section' ) ) {
	class WPBakeryShortCode_Nur_Image_Section extends WPBakeryShortCodesContainer {
		protected function outputTitle( $title ) {
			$icon = $this->settings( 'icon' );
			if ( filter_var( $icon, FILTER_VALIDATE_URL ) ) {
				$icon = '';
			}
			$params = array( 'icon' => $icon, 'is_container' => true );
			return '<h4 class="wpb_element_title"> ' . $this->getIcon( $params ) . esc_html( $title ) . '</h4>';
		}
	}
}

return array(
	'base'          => 'nur_image_section',
	'name'          => __( 'Image Section', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),
	'is_container'  => true,
	'js_view'       => 'VcColumnView',
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_image_section/template.php',

	'params'        => array(
		array(
			'type'       => 'attach_image',
			'param_name' => 'image_id',
			'heading'    => __( 'Image', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'layout',
			'heading'    => __( 'Select layout style', 'nur-plugin' ),
			'value'      => array(
				__( 'Cover Image + Content on Left', 'nur-plugin' )        => 'cover-image content-left',
				__( 'Cover Image + Content on Right', 'nur-plugin' )       => 'cover-image content-right',
				__( 'Boxed Image + Content on Left', 'nur-plugin' )        => 'boxed-image content-left',
				__( 'Boxed Image + Content on Right', 'nur-plugin' )       => 'boxed-image content-right',
				__( 'Background Image + Content on Left', 'nur-plugin' )   => 'bg-image content-left',
				__( 'Background Image + Content in Center', 'nur-plugin' ) => 'bg-image content-center',
				__( 'Background Image + Content on Right', 'nur-plugin' )  => 'bg-image content-right',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'image_mobile',
			'heading'    => 'Hide image on mobile?',
			'value'      => array(
				__( 'Hide', 'nur-plugin' ) => 'hide',
				__( 'Show', 'nur-plugin' ) => 'show',
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
