/* eslint camelcase:off */
( function( $ ) {
	'use strict';

	var vc = window.vc;

	window.NurProjectPreview = vc.shortcode_view.extend( {
		$container: false,
		projectPreviewTemplate: false,

		changeShortcodeParams: function( model ) {
			var params;

			window.NurProjectPreview.__super__.changeShortcodeParams.call( this, model );

			params = _.extend( {}, model.get( 'params' ) );
			if ( ! _.isObject( params ) ) {
				return;
			}

			if ( ! this.$container ) {
				this.$container = this.$el.find( '.nur-vc-project-preview' );
			}
			if ( ! this.projectPreviewTemplate ) {
				this.projectPreviewTemplate = vc.template( this.$container.html(), vc.templateOptions.custom );
			}

			if ( ! params.project_id || params.project_id === '0' ) {
				params.project_title = '<div class="nur-vc-project-preview-error">' +
						'<h2><strong>' + window.nurVC_l10n.project_not_selected + '</strong></h2></div>';
				this.$container.html( $( this.projectPreviewTemplate( { params: params } ) ) ).removeClass( 'is-template' );
				return;
			}

			$.get( {
				url: window.ajaxurl,
				context: this,
				dataType: 'json',
				data: {
					action: 'nur_vc_get_post_title',
					post_id: params.project_id,
					post_type: 'project',
					_vcnonce: window.vcAdminNonce,
				},
			} ).done( function( response ) {
				if ( response && response.success ) {
					params.project_title = '<h2>' + response.data + '</h2>';
				} else {
					params.project_title = '<div class="nur-vc-project-preview-error"><h2><strong>' + response.data + '</strong></h2></div>';
				}
				this.$container.html( $( this.projectPreviewTemplate( { params: params } ) ) ).removeClass( 'is-template' );
			} );
		},
	} );

} ( jQuery ) );
