<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Section_Heading' ) ) {
	class WPBakeryShortCode_Nur_Section_Heading extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_section_heading',
	'name'          => __( 'Section Heading', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_section_heading/template.php',

	'params'        => array(
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'decoration',
			'heading'    => __( 'Decoration', 'nur-plugin' ),
			'value'      => array(
				__( 'No decoration', 'nur-plugin' )   => 'no',
				__( 'Horizontal line', 'nur-plugin' ) => 'line',
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
