<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Testimonials_Carousel' ) ) {
	class WPBakeryShortCode_Nur_Testimonials_Carousel extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_testimonials_carousel',
	'name'          => __( 'Testimonials Carousel', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_testimonials_carousel/template.php',

	'params'        => array(
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 6,
			'heading'     => __( 'Number of items to show', 'nur-plugin' ),
			'description' => __( 'To show all items enter: All', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'layout',
			'heading'    => __( 'Layout', 'nur-plugin' ),
			'value'      => array(
				__( '2 testimonial items per slide', 'nur-plugin' ) => 'cards-2',
				__( '1 testimonial item per slide', 'nur-plugin' )  => 'cards-1',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'dots_nav',
			'heading'    => __( 'Navigation dots', 'nur-plugin' ),
			'value'      => array(
				__( 'Show', 'nur-plugin' ) => 'show',
				__( 'Hide', 'nur-plugin' ) => 'hide',
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'colorpicker',
			'param_name' => 'card_bg',
			'heading'    => __( 'Card Background Color', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
