<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package Nur
 */

?><!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	}
	?>

	<a class="skip-link screen-reader-text" href="#site-navigation"><?php esc_html_e( 'Skip to navigation', 'nur' ); ?></a>
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'nur' ); ?></a>

	<?php get_template_part( 'partials/header/top-bar' ); ?>

	<header id="masthead" class="site-header">
		<?php get_template_part( 'partials/header/site-branding' ); ?>
		<?php get_template_part( 'partials/header/primary-navigation' ); ?>
		<?php get_template_part( 'partials/header/search-bar' ); ?>
		<?php get_template_part( 'partials/header/featured-content' ); ?>
	</header>

	<?php get_template_part( 'partials/header/page-header' ); ?>

	<div id="content" class="site-content" tabindex="-1">
