<?php
/**
 * Nur_Color_Field class
 *
 * @package Nur
 */

namespace Carbon_Fields\Field;

/**
 * Custom color picker field with RGBA support.
 */
class Nur_Color_Field extends Field {
	/**
	 * Underscore template of the field.
	 */
	public function template() {
		?>
		<input id="{{{ id }}}" type="text" name="{{{ name }}}" value="{{ value }}" class="regular-text color-picker" data-alpha="true" />
		<?php
	}

	/**
	 * Hook administration scripts and styles.
	 */
	public static function admin_enqueue_scripts() {
		wp_enqueue_style( 'wp-color-picker-alpha' );
		wp_enqueue_script( 'wp-color-picker-alpha' );
	}
}
