<?php
/**
 * Compatibility with WPBakery Page Builder plugin (formerly Visual Composer)
 *
 * @package Nur
 */

/**
 * Check if Visual Composer is activated on the current page
 */
function nur_vc_is_active_on_page() {
	$vc_status = get_post_meta( get_the_ID(), '_wpb_vc_js_status', true );
	return $vc_status && 'false' !== $vc_status;
}

/**
 * Customize VC settings
 */
function nur_vc_before_init() {
	vc_set_as_theme();
	vc_set_default_editor_post_types( array( 'page', 'service', 'project' ) );
	add_action( 'wp_enqueue_scripts', 'nur_vc_deregister_scripts' );
}
add_action( 'vc_before_init', 'nur_vc_before_init' );

/**
 * Customize VC Row and VC Section elements settings
 */
function nur_vc_override_default_params() {
	$remove_params = array(
		'vc_row'     => array(
			'gap',
			'parallax',
			'parallax_image',
			'parallax_speed_bg',
			'parallax_speed_video',
			'video_bg',
			'video_bg_url',
			'video_bg_parallax',
		),
		'vc_section' => array(
			'full_width',
			'parallax_image',
			'parallax_speed_video',
			'video_bg_parallax',
		),
	);

	$row_full_width = WPBMap::getParam( 'vc_row', 'full_width' );
	$key = array_search( 'stretch_row', $row_full_width['value'], true );
	if ( $key ) {
		unset( $row_full_width['value'][ $key ] );
	}

	$update_params = array(
		'vc_row'     => array( $row_full_width ),
		'vc_section' => array(
			array(
				'type'        => 'checkbox',
				'param_name'  => 'parallax',
				'heading'     => esc_html__( 'Enable background parallax effect?', 'nur' ),
				'description' => esc_html__( 'Adds a subtle background parallax effect when the page is scrolled. The background image can be set in the "Design Options" tab of this dialog.', 'nur' ),
				'value'       => array( esc_html__( 'Yes', 'nur' ) => 'scroll' ),
				'dependency'  => false,
			),
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_speed_bg',
				'heading'     => esc_html__( 'Parallax speed', 'nur' ),
				'description' => esc_html__( 'A decimal number in the [0-1] range. Default value is 0.5', 'nur' ),
				'value'       => '0.5',
				'dependency'  => array(
					'element'   => 'parallax',
					'not_empty' => true,
				),
			),
		),
	);

	foreach ( $remove_params as $shortcode => $params ) {
		foreach ( $params as $param_name ) {
			vc_remove_param( $shortcode, $param_name );
		}
	}

	foreach ( $update_params as $shortcode => $params ) {
		foreach ( $params as $param ) {
			vc_update_shortcode_param( $shortcode, $param );
		}
	}
}
add_action( 'vc_after_init', 'nur_vc_override_default_params' );

/**
 * De-register scripts/styles that are already included with the theme
 */
function nur_vc_deregister_scripts() {
	wp_deregister_style( 'vc_typicons' );
}

/**
 * Enqueue custom VC Backend Editor styles
 */
function nur_enqueue_vc_backend_editor_style() {
	wp_enqueue_style( 'nur-vc-editor-style', get_theme_file_uri( '/assets/css/editor-styles.css' ), array(), NUR_THEME_VERSION );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'nur_enqueue_vc_backend_editor_style' );
