<?php
/**
 * Custom fields for posts and pages
 *
 * @package Nur
 */

/**
 * Use Carbon Fields plugin API to add custom fields meta boxes.
 */
function nur_register_carbon_fields() {
	require_once get_parent_theme_file_path( '/inc/compat/carbon-fields/class-nur-color-field.php' );

	$container = Carbon_Fields\Container::make( 'post_meta', esc_html__( 'Page Settings', 'nur' ) )
		->show_on_post_type( array( 'post', 'page', 'service', 'project' ) )
		->set_priority( 'default' );

	$container->add_fields( array(
		Carbon_Fields\Field::make( 'select', 'nur_show_page_header', esc_html__( 'Display Page Header', 'nur' ) )
			->add_options( array(
				''      => esc_html__( 'Default', 'nur' ),
				'true'  => esc_html__( 'Show', 'nur' ),
				'false' => esc_html__( 'Hide', 'nur' ),
			) ),
	) );

	if ( nur_bcn_is_active() ) {
		$container->add_fields( array(
			Carbon_Fields\Field::make( 'select', 'nur_show_breadcrumbs', esc_html__( 'Display Breadcurmbs', 'nur' ) )
				->add_options( array(
					''      => esc_html__( 'Default', 'nur' ),
					'true'  => esc_html__( 'Show', 'nur' ),
					'false' => esc_html__( 'Hide', 'nur' ),
				) )
				->set_conditional_logic( array(
					array(
						'field'   => 'nur_show_page_header',
						'value'   => 'false',
						'compare' => '!=',
					),
				) ),
		) );
	}

	$container->add_fields( array(
		Carbon_Fields\Field::make( 'image', 'nur_header_image_id', esc_html__( 'Override Header Image', 'nur' ) )
			->set_conditional_logic( array(
				array(
					'field'   => 'nur_show_page_header',
					'value'   => 'false',
					'compare' => '!=',
				),
			) ),
		Carbon_Fields\Field::make( 'nur_color', 'nur_header_bg_color', esc_html__( 'Override Header Background Color', 'nur' ) )
			->set_conditional_logic( array(
				array(
					'field'   => 'nur_show_page_header',
					'value'   => 'false',
					'compare' => '!=',
				),
			) ),
	) );
}
add_action( 'carbon_register_fields', 'nur_register_carbon_fields' );
