<?php
/**
 * Theme default values
 *
 * @package Nur
 */

/**
 * A global array with theme default values.
 */
global $nur_defaults;

if ( ! isset( $nur_defaults ) ) {
	$nur_defaults = array(
		'primary_color'          => '#0099ff',
		'primary_color_darker'   => '#0071bd',
		'site_title_color'       => '#0099ff',
		'header_bg_color'        => 'rgba(0,113,189,0.1)',
		'footer_bg_color'        => 'rgba(255,255,255,1)',
		'footer_bottom_bg_color' => 'rgba(0,113,189,1)',
		/* translators: 1: is a link to the author portfolio page, 2: is the author name */
		'footer_tagline'         => sprintf( __( '&copy; 2017 Nur WordPress Theme by <a href="%1$s">%2$s</a>', 'nur' ), 'https://themeforest.net/user/brotherstheme', 'BrothersTheme' ),
	);
}

/**
 * Retrieve theme default value from the global array.
 */
function nur_get_default( $key ) {
	global $nur_defaults;
	return isset( $nur_defaults[ $key ] ) ? $nur_defaults[ $key ] : false;
}
