<?php
/**
 * TGM Plugin Activation integration to allow easy installation of recommended plugins.
 *
 * @package Nur
 */

require_once get_parent_theme_file_path( '/inc/tgmpa/class-tgm-plugin-activation.php' );

/**
 * Provide a list of recommended plugins.
 */
function nur_register_recommended_plugins() {
	$plugins = array(
		array(
			'name'     => esc_html__( 'Nur Custom Post Types & Shortcodes Plugin', 'nur' ),
			'slug'     => 'nur-plugin',
			'source'   => get_parent_theme_file_path( '/inc/tgmpa/plugins/nur-plugin.zip' ),
			'required' => false,
			'version'  => '1.6.10',
		),
		array(
			'name'     => esc_html__( 'Breadcrumb NavXT', 'nur' ),
			'slug'     => 'breadcrumb-navxt',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Carbon Fields', 'nur' ),
			'slug'     => 'carbon-fields',
			'source'   => get_parent_theme_file_path( '/inc/tgmpa/plugins/carbon-fields.zip' ),
			'required' => false,
			'version'  => '1.6.0',
		),
		array(
			'name'     => esc_html__( 'Contact Form 7', 'nur' ),
			'slug'     => 'contact-form-7',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Easy Google Fonts', 'nur' ),
			'slug'     => 'easy-google-fonts',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'WPBakery Page Builder', 'nur' ),
			'slug'     => 'js_composer',
			'source'   => get_parent_theme_file_path( '/inc/tgmpa/plugins/js_composer.zip' ),
			'required' => false,
			'version'  => '6.8.0',
		),
		array(
			'name'     => esc_html__( 'One Click Demo Import', 'nur' ),
			'slug'     => 'one-click-demo-import',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Slider Revolution', 'nur' ),
			'slug'     => 'revslider',
			'source'   => get_parent_theme_file_path( '/inc/tgmpa/plugins/revslider.zip' ),
			'required' => false,
			'version'  => '6.5.14',
		),
		array(
			'name'     => esc_html__( 'WooCommerce', 'nur' ),
			'slug'     => 'woocommerce',
			'required' => false,
		),
	);

	tgmpa( $plugins, array( 'is_automatic' => true ) );
}
add_action( 'tgmpa_register', 'nur_register_recommended_plugins' );
