<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_height
 * @var $columns_placement
 * @var $content_placement
 * @var $video_bg
 * @var $video_bg_url
 * @var $parallax
 * @var $parallax_speed_bg
 * @var $css
 * @var $el_id
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $flex_row = $columns_placement = $content_placement = $parallax = $css = $el_id = $video_bg = $video_bg_url = $css_animation = '';
$disable_element = '';
$output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$css_classes = array(
	'vc_section',
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_section-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_section-flex';
}

if ( ! $parallax_speed_bg ) {
	$parallax_speed_bg = '0.5';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

if ( $parallax ) {
	$css_classes[] = 'jarallax';
	$wrapper_attributes[] = 'data-jarallax';
	$wrapper_attributes[] = 'data-type="' . esc_attr( $parallax ) . '"';
	$wrapper_attributes[] = 'data-speed="' . esc_attr( $parallax_speed_bg ) . '"';
	$wrapper_attributes[] = 'data-no-android="true"';
	$wrapper_attributes[] = 'data-no-ios="true"';
	if ( $has_video_bg ) {
		$wrapper_attributes[] = 'data-jarallax-video="' . esc_attr( $video_bg_url ) . '"';
	}
} elseif ( $has_video_bg ) {
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
	$css_classes[] = 'vc_video-bg-container';
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
?>

<section <?php echo implode( ' ', $wrapper_attributes ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
	<?php echo wpb_js_remove_wpautop( $content ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</section>
