<?php
/**
 * Compatibility with Breadcrumb NavXT plugin
 *
 * @package Nur
 */

/**
 * Query Breadcrumb NavXT plugin activation
 */
function nur_bcn_is_active() {
	return function_exists( 'bcn_display' );
}

/**
 * Customize default settings of the Breadcrumb NavXT plugin
 */
function nur_bcn_settings_init( $opt ) {
	if ( ! $opt ) {
		$opt = array();
	}
	$opt['bmainsite_display'] = false;
	$opt['bblog_display'] = true;
	$opt['hseparator'] = ' / ';
	$opt['Spost_post_taxonomy_type'] = 'BCN_POST_PARENT';
	return $opt;
}
add_filter( 'bcn_settings_init', 'nur_bcn_settings_init' );

/**
 * Remove the title of the current post/page item from the breadcrumb trail to avoid duplication,
 * since breadcrumbs are displayed right next to the page title.
 */
function nur_bcn_remove_post_title( $trail ) {
	// Remove the current item from the trail
	if ( ! is_404() && ! empty( $trail->breadcrumbs ) && in_array( 'current-item', $trail->breadcrumbs[0]->get_types(), true ) ) {
		unset( $trail->breadcrumbs[0] );
		$trail->breadcrumbs = array_values( $trail->breadcrumbs );
	}

	// Do not display the trail if there is only one item
	if ( 1 === count( $trail->breadcrumbs ) ) {
		$trail->breadcrumbs = array();
	}
}
add_action( 'bcn_after_fill', 'nur_bcn_remove_post_title' );

/**
 * Add Breadcrumb NavXT plugin's allowed HTML to allow breadcrumbs sanitiziation with wp_kses().
 */
function nur_bcn_wp_kses_allowed_html( $tags, $context ) {
	global $breadcrumb_navxt;
	if ( 'breadcrumb_navxt' === $context && isset( $breadcrumb_navxt ) ) {
		return $breadcrumb_navxt->allowed_html( $tags );
	}
	return $tags;
}
add_filter( 'wp_kses_allowed_html', 'nur_bcn_wp_kses_allowed_html', 10, 2 );

/**
 * Append the separator which was set in the plugin settings, to the end of the given trail string.
 */
function nur_bcn_append_separator( $trail ) {
	$opt = nur_bcn_get_options();
	if ( isset( $opt['hseparator'] ) ) {
		$trail .= $opt['hseparator'];
	}
	return $trail;
}

/**
 * Get the Breadcrumb NavXT plugin options
 *
 * This function is copied from the plugin's source code with small formatting changes.
 */
function nur_bcn_get_options() {
	// Grab the current settings for the current local site from the db
	$opt = get_option( 'bcn_options' );

	// If we're in multisite mode, look at the three BCN_SETTINGS globals
	if ( is_multisite() ) {
		if ( defined( 'BCN_SETTINGS_USE_NETWORK' ) && BCN_SETTINGS_USE_NETWORK ) {
			// Grab the current network wide settings
			$opt = wp_parse_args( get_site_option( 'bcn_options' ), $opt );
		} elseif ( defined( 'BCN_SETTINGS_FAVOR_LOCAL' ) && BCN_SETTINGS_FAVOR_LOCAL ) {
			// Grab the current settings for the current local site from the db
			$opt = wp_parse_args( get_option( 'bcn_options' ), $opt );
		} elseif ( defined( 'BCN_SETTINGS_FAVOR_NETWORK' ) && BCN_SETTINGS_FAVOR_NETWORK ) {
			// Grab the current settings from the db
			$opt = wp_parse_args( get_site_option( 'bcn_options' ), get_option( 'bcn_options' ) );
		}
	}

	return $opt;
}
