<?php
/**
 * Compatibility with Easy Google Fonts plugin
 *
 * @package Nur
 */

/**
 * Change Typography panel order in the Customizer
 */
function nur_tt_font_get_panels( $panels ) {
	if ( isset( $panels['tt_font_typography_panel'] ) ) {
		$panels['tt_font_typography_panel']['priority'] = 140; // after Blog Settings
	}
	return $panels;
}
add_filter( 'tt_font_get_panels', 'nur_tt_font_get_panels' );

/**
 * Add additional typography options for the theme
 */
function nur_tt_font_get_option_parameters( $options ) {
	$theme_options = array(
		'nur_tt_body'     => array(
			'name'       => 'nur_tt_body',
			'title'      => esc_html__( 'Body', 'nur' ),
			'properties' => array( 'selector' => apply_filters( 'nur_tt_body', 'body' ) ),
		),
		'nur_tt_headings' => array(
			'name'       => 'nur_tt_headings',
			'title'      => esc_html__( 'Headings', 'nur' ),
			'properties' => array( 'selector' => apply_filters( 'nur_tt_headings', 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6' ) ),
		),
	);
	$options = array_merge( $theme_options, $options );
	return $options;
}
add_filter( 'tt_font_get_option_parameters', 'nur_tt_font_get_option_parameters' );

/**
 * Override CSS selector for h1-h6 headings
 */
function nur_tt_default_heading_filters() {
	// The missing h in 'h1' is intentional, because that's how the filter is called in EGF plugin.
	foreach ( array( '1', 'h2', 'h3', 'h4', 'h5', 'h6' ) as $level ) {
		add_filter(
			'tt_default_heading_' . $level,
			function() use ( $level ) {
				return sprintf( 'h%1$d, .h%1$d', str_replace( 'h', '', $level ) );
			}
		);
	}
}
add_filter( 'init', 'nur_tt_default_heading_filters' );
