<?php
/**
 * Custom colors CSS.
 *
 * @package Nur
 */

/**
 * Hooks to wp_head to print CSS for user defined colors.
 */
function nur_print_custom_colors() {
	nur_custom_color_css_wrap( 'primary_color' );
	nur_custom_color_css_wrap( 'primary_color_darker' );
}
add_action( 'wp_head', 'nur_print_custom_colors' );

/**
 * Prints the style tag and CSS for the given user defined color.
 */
function nur_custom_color_css_wrap( $color_name ) {
	global $nur_defaults;
	$color = get_theme_mod( $color_name, $nur_defaults[ $color_name ] );
	if ( $nur_defaults[ $color_name ] === $color && ! is_customize_preview() ) {
		return;
	}
	?>
	<style id="<?php echo 'nur-custom-' . esc_attr( $color_name ); ?>" <?php if ( is_customize_preview() ) { echo 'data-current-color="' . esc_attr( $color ) . '"'; } ?>>
		<?php do_action( 'nur_print_custom_' . $color_name . '_css', $color ); ?>
	</style>
	<?php
}

/**
 * Prints the CSS for user defined Primary color.
 */
function nur_print_primary_color_css( $primary_color ) {
	echo '
a:hover,
a:focus,
blockquote::before,
.btn:not(.btn-primary),
.btn:not(.btn-primary):hover, .btn:not(.btn-primary):focus,
.search-form .search-submit:hover,
.comment-form .submit,
.comment-form .submit:hover, .comment-form .submit:focus,
.post-password-form input[type="submit"],
.post-password-form input[type="submit"]:hover, .post-password-form input[type="submit"]:focus,
.widget:not(.widget_text) a:hover,
.project-card--style-2 .project-card-title,
.counter-box-number,
.feature-box--small-icon .feature-box-icon,
.feature-box--large-icon .feature-box-icon,
.secondary-navigation a:hover,
.entry-title a:hover,
.entry-meta a:hover,
.entry-more-link,
.entry-more-link:hover, .entry-more-link:focus,
.entry--preview .entry-date a,
.comments-nav a:hover,
.comments-nav a:focus,
.comment-date a:hover,
.comment-actions a:hover,
.header-featured-content-icon:not(.header-featured-content-icon--circled),
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
.woocommerce #respond input#submit,
.woocommerce a.added_to_cart,
.woocommerce a.button:hover, .woocommerce a.button:focus,
.woocommerce button.button:hover,
.woocommerce button.button:focus,
.woocommerce input.button:hover,
.woocommerce input.button:focus,
.woocommerce #respond input#submit:hover,
.woocommerce #respond input#submit:focus,
.woocommerce a.added_to_cart:hover,
.woocommerce a.added_to_cart:focus,
.woocommerce #review_form #respond .comment-form-rating .stars a,
.vc_wp_custommenu ul li:hover a,
.vc_wp_custommenu ul li.current-menu-item a {
	color: ' . esc_html( $primary_color ) . ';
}

.text-primary {
	color: ' . esc_html( $primary_color ) . ' !important;
}

.btn,
input[type="text"]:focus,
input[type="email"]:focus,
input[type="url"]:focus,
input[type="password"]:focus,
input[type="search"]:focus,
input[type="number"]:focus,
input[type="tel"]:focus,
input[type="range"]:focus,
input[type="date"]:focus,
input[type="month"]:focus,
input[type="week"]:focus,
input[type="time"]:focus,
input[type="datetime"]:focus,
input[type="datetime-local"]:focus,
input[type="color"]:focus,
textarea:focus,
select:focus,
.comment-form .submit,
.post-password-form input[type="submit"],
.entry-more-link,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
.woocommerce #respond input#submit,
.woocommerce a.added_to_cart,
.footer-widgets .widget-title::after {
	border-color: ' . esc_html( $primary_color ) . ';
}

.btn-primary,
.section-heading .decor-line::after,
.sticky .entry-sticky-badge::before,
.header-featured-content-icon--circled,
.woocommerce span.onsale,
.woocommerce div.product form.cart .button,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce #respond input#submit.alt,
.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
#add_payment_method .wc-proceed-to-checkout a.checkout-button,
.woocommerce-cart #payment #place_order,
.woocommerce-checkout #payment #place_order,
#add_payment_method #payment #place_order {
	background-color: ' . esc_html( $primary_color ) . ';
}

.bg-primary {
	background-color: ' . esc_html( $primary_color ) . ' !important;
}

@media (max-width: 991px) {
	.primary-navigation ul li.current-menu-item > a {
		color: ' . esc_html( $primary_color ) . ';
	}
}

@media (min-width: 992px) {
	.service-card:hover .service-card-title,
	.post-card:hover .post-card-title,
	.primary-navigation ul li:hover > a,
	.primary-navigation ul li.current-menu-item > a,
	.primary-navigation ul li.current-menu-ancestor > a {
		color: ' . esc_html( $primary_color ) . ';
	}

	.woocommerce ul.products li.product:hover .button {
		background-color: ' . esc_html( $primary_color ) . ';
	}
}
';
}
add_action( 'nur_print_custom_primary_color_css', 'nur_print_primary_color_css' );

/**
 * Prints the CSS for user defined Darker primary color.
 */
function nur_print_primary_color_darker_css( $primary_color_darker ) {
	echo '
a,
.entry--preview .entry-date a:hover {
	color: ' . esc_html( $primary_color_darker ) . ';
}

.btn-primary:hover, .btn-primary:focus,
.woocommerce div.product form.cart .button:hover, .woocommerce div.product form.cart .button:focus,
.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button:focus,
.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:hover,
.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:focus,
#add_payment_method .wc-proceed-to-checkout a.checkout-button:hover,
#add_payment_method .wc-proceed-to-checkout a.checkout-button:focus,
.woocommerce-cart #payment #place_order:hover, .woocommerce-cart #payment #place_order:focus,
.woocommerce-checkout #payment #place_order:hover,
.woocommerce-checkout #payment #place_order:focus,
#add_payment_method #payment #place_order:hover,
#add_payment_method #payment #place_order:focus {
	border-color: ' . esc_html( $primary_color_darker ) . ';
	background-color: ' . esc_html( $primary_color_darker ) . ';
}

@media (min-width: 992px) {
	.project-card--style-2 .project-card:hover .project-card-title {
		color: ' . esc_html( $primary_color_darker ) . ';
	}
}
';
}
add_action( 'nur_print_custom_primary_color_darker_css', 'nur_print_primary_color_darker_css' );
