<?php
namespace Nur\Customize;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Customizer color control with RGBA support.
 */
class Color_Alpha_Control extends \WP_Customize_Control {
	/**
	 * Type.
	 *
	 * @var string
	 */
	public $type = 'color_alpha';

	/**
	 * Enqueue scripts/styles for the color picker.
	 */
	public function enqueue() {
		wp_enqueue_style( 'wp-color-picker-alpha' );
		wp_enqueue_script( 'nur-customize-color-alpha-control', get_theme_file_uri( 'assets/customizer/color-alpha-control.js' ), array( 'customize-controls', 'wp-color-picker-alpha' ), NUR_THEME_VERSION, true );
	}

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 */
	public function to_json() {
		parent::to_json();
		$this->json['defaultValue'] = $this->setting->default;
	}

	/**
	 * Don't render the control content from PHP, as it's rendered via JS on load.
	 */
	public function render_content() {}

	/**
	 * Render a JS template for the content of the color picker control.
	 */
	public function content_template() {
		?>
		<# var defaultValue = '#RRGGBB', defaultValueAttr = '';
		if ( data.defaultValue && _.isString( data.defaultValue ) ) {
			defaultValue = data.defaultValue;
			defaultValueAttr = ' data-default-color=' + defaultValue; // Quotes added automatically.
		} #>
		<# if ( data.label ) { #>
			<span class="customize-control-title">{{{ data.label }}}</span>
		<# } #>
		<# if ( data.description ) { #>
			<span class="description customize-control-description">{{{ data.description }}}</span>
		<# } #>
		<div class="customize-control-content">
			<label><span class="screen-reader-text">{{{ data.label }}}</span>
			<input class="color-picker-alpha" type="text" maxlength="7" placeholder="{{ defaultValue }}" {{ defaultValueAttr }} data-alpha="true" />
			</label>
		</div>
		<?php
	}
}
