<?php
/**
 * Custom post types configuration
 *
 * @package Nur_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Register the custom post types to be used in our theme
 */
function nur_cpt_register_post_types() {
	// Add Excerpt support for Pages
	add_post_type_support( 'page', 'excerpt' );

	// Service
	$service_labels = array(
		'name'               => __( 'Services', 'nur-plugin' ),
		'singular_name'      => __( 'Service', 'nur-plugin' ),
		'add_new'            => __( 'Add New', 'nur-plugin' ),
		'add_new_item'       => __( 'Add New Service', 'nur-plugin' ),
		'edit_item'          => __( 'Edit Service', 'nur-plugin' ),
		'new_item'           => __( 'New Service', 'nur-plugin' ),
		'all_items'          => __( 'All Services', 'nur-plugin' ),
		'view_item'          => __( 'View Service', 'nur-plugin' ),
		'search_items'       => __( 'Search Services', 'nur-plugin' ),
		'not_found'          => __( 'No Service found', 'nur-plugin' ),
		'not_found_in_trash' => __( 'No Service found in Trash', 'nur-plugin' ),
		'menu_name'          => __( 'Services', 'nur-plugin' ),
		'parent_item'        => __( 'Parent Service', 'nur-plugin' ),
		'parent_item_colon'  => __( 'Parent Service:', 'nur-plugin' ),
	);
	$service_args = array(
		'labels'        => $service_labels,
		'public'        => true,
		'show_ui'       => true,
		'menu_icon'     => 'dashicons-clipboard',
		'menu_position' => 20,
		'hierarchical'  => true,
		'has_archive'   => false,
		'map_meta_cap'  => true,
		'show_in_rest'  => true,
		'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
	);
	register_post_type( 'service', $service_args );
	// Service Category taxonomy
	$service_category_labels = array(
		'name'                  => __( 'Service Categories', 'nur-plugin' ),
		'singular_name'         => __( 'Service Category', 'nur-plugin' ),
		'menu_name'             => __( 'Service Categories', 'nur-plugin' ),
		'search_items'          => __( 'Search Service Categories', 'nur-plugin' ),
		'all_items'             => __( 'All Service Categories', 'nur-plugin' ),
		'edit_item'             => __( 'Edit Service Category', 'nur-plugin' ),
		'update_item'           => __( 'Update Service Category', 'nur-plugin' ),
		'add_new_item'          => __( 'Add new Service Category', 'nur-plugin' ),
		'new_item_name'         => __( 'New Service Category', 'nur-plugin' ),
		'choose_from_most_used' => __( 'Choose from the most used categories', 'nur-plugin' ),
	);
	$service_category_args = array(
		'labels'            => $service_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_category', 'service', $service_category_args );
	// Service Tag taxonomy
	$service_tag_labels = array(
		'name'          => __( 'Service Tags', 'nur-plugin' ),
		'singular_name' => __( 'Service Tag', 'nur-plugin' ),
		'menu_name'     => __( 'Service Tags', 'nur-plugin' ),
		'search_items'  => __( 'Search Service Tags', 'nur-plugin' ),
		'all_items'     => __( 'All Service Tags', 'nur-plugin' ),
		'edit_item'     => __( 'Edit Service Tag', 'nur-plugin' ),
		'update_item'   => __( 'Update Service Tag', 'nur-plugin' ),
		'add_new_item'  => __( 'Add new Service Tag', 'nur-plugin' ),
		'new_item_name' => __( 'New Service Tag', 'nur-plugin' ),
	);
	$service_tag_args = array(
		'labels'            => $service_tag_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_tag', 'service', $service_tag_args );

	// Project
	$project_labels = array(
		'name'               => __( 'Projects', 'nur-plugin' ),
		'singular_name'      => __( 'Project', 'nur-plugin' ),
		'add_new'            => __( 'Add New', 'nur-plugin' ),
		'add_new_item'       => __( 'Add New Project', 'nur-plugin' ),
		'edit_item'          => __( 'Edit Project', 'nur-plugin' ),
		'new_item'           => __( 'New Project', 'nur-plugin' ),
		'all_items'          => __( 'All Portfolio Projects', 'nur-plugin' ),
		'view_item'          => __( 'View Project', 'nur-plugin' ),
		'search_items'       => __( 'Search Projects', 'nur-plugin' ),
		'not_found'          => __( 'No Project found', 'nur-plugin' ),
		'not_found_in_trash' => __( 'No Project found in Trash', 'nur-plugin' ),
		'menu_name'          => __( 'Portfolio', 'nur-plugin' ),
	);
	$project_args = array(
		'labels'        => $project_labels,
		'public'        => true,
		'show_ui'       => true,
		'menu_icon'     => 'dashicons-portfolio',
		'menu_position' => 20,
		'has_archive'   => false,
		'map_meta_cap'  => true,
		'show_in_rest'  => true,
		'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
	);
	register_post_type( 'project', $project_args );
	// Project Category taxonomy
	$project_category_labels = array(
		'name'                  => __( 'Project Categories', 'nur-plugin' ),
		'singular_name'         => __( 'Project Category', 'nur-plugin' ),
		'menu_name'             => __( 'Project Categories', 'nur-plugin' ),
		'search_items'          => __( 'Search Project Categories', 'nur-plugin' ),
		'all_items'             => __( 'All Project Categories', 'nur-plugin' ),
		'edit_item'             => __( 'Edit Project Category', 'nur-plugin' ),
		'update_item'           => __( 'Update Project Category', 'nur-plugin' ),
		'add_new_item'          => __( 'Add new Project Category', 'nur-plugin' ),
		'new_item_name'         => __( 'New Project Category', 'nur-plugin' ),
		'choose_from_most_used' => __( 'Choose from the most used categories', 'nur-plugin' ),
	);
	$project_category_args = array(
		'labels'            => $project_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'project_category', 'project', $project_category_args );
	// Project Tag taxonomy
	$project_tag_labels = array(
		'name'          => __( 'Project Tags', 'nur-plugin' ),
		'singular_name' => __( 'Project Tag', 'nur-plugin' ),
		'menu_name'     => __( 'Project Tags', 'nur-plugin' ),
		'search_items'  => __( 'Search Project Tags', 'nur-plugin' ),
		'all_items'     => __( 'All Project Tags', 'nur-plugin' ),
		'edit_item'     => __( 'Edit Project Tag', 'nur-plugin' ),
		'update_item'   => __( 'Update Project Tag', 'nur-plugin' ),
		'add_new_item'  => __( 'Add new Project Tag', 'nur-plugin' ),
		'new_item_name' => __( 'New Project Tag', 'nur-plugin' ),
	);
	$project_tag_args = array(
		'labels'            => $project_tag_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'project_tag', 'project', $project_tag_args );

	// Testimonial
	$testimonial_labels = array(
		'name'               => __( 'Testimonials', 'nur-plugin' ),
		'singular_name'      => __( 'Testimonial', 'nur-plugin' ),
		'add_new'            => __( 'Add New', 'nur-plugin' ),
		'add_new_item'       => __( 'Add New Testimonial', 'nur-plugin' ),
		'edit_item'          => __( 'Edit Testimonial', 'nur-plugin' ),
		'new_item'           => __( 'New Testimonial', 'nur-plugin' ),
		'all_items'          => __( 'All Testimonials', 'nur-plugin' ),
		'view_item'          => __( 'View Testimonial', 'nur-plugin' ),
		'search_items'       => __( 'Search Testimonials', 'nur-plugin' ),
		'not_found'          => __( 'No Testimonial found', 'nur-plugin' ),
		'not_found_in_trash' => __( 'No Testimonial found in Trash', 'nur-plugin' ),
		'menu_name'          => __( 'Testimonials', 'nur-plugin' ),
		'parent_item'        => __( 'Parent Testimonial', 'nur-plugin' ),
		'parent_item_colon'  => __( 'Parent Testimonial:', 'nur-plugin' ),
	);
	$testimonial_args = array(
		'labels'              => $testimonial_labels,
		'public'              => false,
		'show_ui'             => true,
		'menu_icon'           => 'dashicons-format-quote',
		'menu_position'       => 20,
		'has_archive'         => false,
		'map_meta_cap'        => true,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'testimonial', $testimonial_args );
	// Testimonial Category taxonomy
	$testimonial_category_labels = array(
		'name'          => __( 'Testimonial Categories', 'nur-plugin' ),
		'singular_name' => __( 'Testimonial Category', 'nur-plugin' ),
		'menu_name'     => __( 'Testimonial Categories', 'nur-plugin' ),
		'search_items'  => __( 'Testimonial Search categories', 'nur-plugin' ),
		'all_items'     => __( 'All Testimonial Categories', 'nur-plugin' ),
		'edit_item'     => __( 'Edit Testimonial Category', 'nur-plugin' ),
		'update_item'   => __( 'Update Testimonial Category', 'nur-plugin' ),
		'add_new_item'  => __( 'Add new Testimonial Category', 'nur-plugin' ),
		'new_item_name' => __( 'New Testimonial Category', 'nur-plugin' ),
	);
	$testimonial_category_args = array(
		'labels'            => $testimonial_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'testimonial_category', 'testimonial', $testimonial_category_args );
}
add_action( 'init', 'nur_cpt_register_post_types' );

/**
 * Disable JetPack's related posts feature for Single Service Page
 */
function nur_cpt_disable_jetpack_relatedposts( $options ) {
	if ( is_singular( 'service' ) ) {
		$options['enabled'] = false;
	}
	return $options;
}
add_filter( 'jetpack_relatedposts_filter_options', 'nur_cpt_disable_jetpack_relatedposts' );

/**
 * Integrate with Carbon Fields plugin to add some useful custom fields meta boxes
 * for our custom post types.
 */
function nur_cpt_register_carbon_fields() {
	require_once NUR_PLUGIN_DIR_PATH . 'carbon-fields/carbon-fields-config.php';
}
add_action( 'carbon_register_fields', 'nur_cpt_register_carbon_fields' );

/**
 * Add the Featured Image column to the list of posts in the Dashboard
 */
function nur_cpt_manage_posts_columns( $columns, $post_type ) {
	if ( 'product' === $post_type ) {
		return $columns;
	}
	$columns['featured-image'] = __( 'Featured Image', 'nur-plugin' );
	return $columns;
}
add_filter( 'manage_posts_columns', 'nur_cpt_manage_posts_columns', 10, 2 );

/**
 * Handle the rendering of the Featured Image column
 */
function nur_cpt_manage_posts_custom_column( $column, $post_id ) {
	if ( 'featured-image' === $column ) {
		echo get_the_post_thumbnail( $post_id, array( 100, 100 ) );
	}
}
add_action( 'manage_pages_custom_column', 'nur_cpt_manage_posts_custom_column', 10, 2 );
add_action( 'manage_posts_custom_column', 'nur_cpt_manage_posts_custom_column', 10, 2 );
