<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $image_id
 * @var $layout
 * @var $image_mobile
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$wrapper_class = 'image-section';
$wrapper_class .= implode( '', array_map( function( $mod ) {
	return ' image-section--' . $mod;
}, explode( ' ', $layout ) ) );
if ( 'hide' === $image_mobile ) {
	$wrapper_class .= ' image-section--image-mobile-hide';
}

$content_class = 'image-section-content';
$content_class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$content_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $content_class, $this->settings['base'], $atts );

?>

<div class="<?php echo esc_attr( $wrapper_class ); ?>">

	<div class="image-section-image">
		<?php
		if ( ! empty( $image_id ) ) {
			echo wp_get_attachment_image( $image_id, 'full' );
		}
		?>
	</div>

	<div class="container clearfix">
		<section class="<?php echo esc_attr( $content_class ); ?>">
			<?php echo wpb_js_remove_wpautop( $content ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</section>
	</div>

</div>
