<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Project_Preview' ) ) {
	class WPBakeryShortCode_Nur_Project_Preview extends WPBakeryShortCode {
	}
}

return array(
	'base'              => 'nur_project_preview',
	'name'              => __( 'Project Preview', 'nur-plugin' ),
	'category'          => __( 'Nur WP Theme', 'nur-plugin' ),
	'html_template'     => NUR_VC_SHORTCODES_PATH . 'nur_project_preview/template.php',

	'js_view'           => 'NurProjectPreview',
	'custom_markup'     => '{{title}}<div class="nur-vc-project-preview is-template">{{{ params.project_title }}}</div>',
	'admin_enqueue_js'  => NUR_VC_SHORTCODES_URL . 'nur_project_preview/backend_view.js',
	'admin_enqueue_css' => NUR_VC_SHORTCODES_URL . 'nur_project_preview/backend_view.css',

	'params'            => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'project_id',
			'heading'    => __( 'Select Project', 'nur-plugin' ),
			'value'      => nur_vc_get_posts_list( 'project', array( '' => 0 ) ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'display_style',
			'heading'    => __( 'Display Style', 'nur-plugin' ),
			'value'      => array(
				__( 'Style 1', 'nur-plugin' ) => 'style-1',
				__( 'Style 2', 'nur-plugin' ) => 'style-2',
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'image_size',
			'heading'     => __( 'Image size', 'nur-plugin' ),
			'description' => __( 'Enter preferred image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave blank to use default size.', 'nur-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'colorpicker',
			'param_name' => 'title_bg_color',
			'heading'    => __( 'Title Background Color', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
			'dependency' => array( 'element' => 'display_style', 'value' => array( 'style-1' ) ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
