<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $project_id
 * @var $display_style
 * @var $image_size
 * @var $el_class
 * @var $title_bg_color
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$project_class = 'project-card';
$project_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$project_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $project_class, $this->settings['base'], $atts );

if ( $display_style ) {
	$project_class .= ' project-card--' . $display_style;
}

$project = $project_id ? get_post( $project_id ) : false;
if ( $project && 'project' !== $project->post_type ) {
	$project = false;
}

if ( preg_match_all( '/(\d+)x(\d+)/', $image_size, $sizes ) && isset( $sizes[1][0] ) ) {
	$image_size = array( $sizes[1][0], $sizes[2][0] );
} elseif ( empty( $image_size ) ) {
	$image_size = 'nur_medium';
}

$title_style = '';
if ( $title_bg_color ) {
	$title_style .= 'background-color: ' . $title_bg_color . ';';
}

?>

<?php if ( ! $project ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'Project not selected', 'nur-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please select a project from the element settings.', 'nur-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $project_class ); ?>">
		<a href="<?php echo esc_url( get_permalink( $project ) ); ?>" rel="bookmark">
			<div class="project-card-image"><?php echo get_the_post_thumbnail( $project, $image_size ); ?></div>
			<h4 class="project-card-title" <?php if ( $title_style ) { echo 'style="' . esc_attr( $title_style ) . '"'; } ?>><?php echo get_the_title( $project ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></h4>
		</a>
	</div>

<?php endif; ?>
