<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_Nur_Projects_Grid' ) ) {
	class WPBakeryShortCode_Nur_Projects_Grid extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'nur_projects_grid',
	'html_template' => NUR_VC_SHORTCODES_PATH . 'nur_projects_grid/template.php',
	'name'          => __( 'Projects Grid', 'nur-plugin' ),
	'category'      => __( 'Nur WP Theme', 'nur-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'item_display_style',
			'heading'    => __( 'Item Display Style', 'nur-plugin' ),
			'value'      => array(
				__( 'Style 1', 'nur-plugin' ) => 'style-1',
				__( 'Style 2', 'nur-plugin' ) => 'style-2',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'project_tag',
			'heading'    => __( 'Only show items tagged in', 'nur-plugin' ),
			'value'      => nur_vc_get_taxonomy_terms( 'project_tag', array( 'All' => '' ) ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 'All',
			'heading'     => __( 'Number of items to show', 'nur-plugin' ),
			'description' => __( 'To show all items enter: All', 'nur-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'show_category_filter',
			'heading'    => __( 'Show Filter by Category?', 'nur-plugin' ),
			'value'      => array(
				__( 'Hide', 'nur-plugin' ) => 'no',
				__( 'Show', 'nur-plugin' ) => 'yes',
			),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'default_filter_text',
			'value'      => __( 'All', 'nur-plugin' ),
			'heading'    => __( 'Default filter title', 'nur-plugin' ),
			'dependency' => array( 'element' => 'show_category_filter', 'value' => 'yes' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'nur-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nur-plugin' ),
		),
		array(
			'type'       => 'colorpicker',
			'param_name' => 'title_bg_color',
			'heading'    => __( 'Title Background Color', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
			'dependency' => array( 'element' => 'item_display_style', 'value' => array( 'style-1' ) ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'nur-plugin' ),
			'group'      => __( 'Design Options', 'nur-plugin' ),
		),
	),
);
