<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $display_style
 * @var $posts_per_page
 * @var $show_category_filter
 * @var $default_filter_text
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'all' === strtolower( $posts_per_page ) ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
) );

$grid_class = 'services-grid';
$grid_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$grid_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $grid_class, $this->settings['base'], $atts );

$show_category_filter = 'yes' === $show_category_filter;

$isotope_options = false;
if ( $show_category_filter ) {
	$isotope_options = array(
		'itemSelector' => '.services-grid-item',
		'layoutMode'   => 'fitRows',
	);
}

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'nur-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services items to show.', 'nur-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $grid_class ); ?>">

		<div class="services-grid-inner"
			<?php if ( $isotope_options ) { echo 'data-isotope="' . esc_attr( wp_json_encode( $isotope_options ) ) . '"'; } ?>
			<?php if ( $show_category_filter ) { echo 'data-default-filter-text="' . esc_attr( $default_filter_text ) . '"'; } ?>>

			<?php
			while ( $query->have_posts() ) : $query->the_post();
				$categories = $show_category_filter ? nur_vc_get_the_terms( get_post(), 'service_category' ) : false;
				?>

				<div class="services-grid-item" <?php if ( $categories ) { echo 'data-categories="' . esc_attr( wp_json_encode( $categories ) ) . '"'; } ?>>

					<div class="service-card">
						<a href="<?php the_permalink(); ?>" rel="bookmark">
							<div class="service-card-image"><?php the_post_thumbnail( 'nur_small' ); ?></div>
							<h4 class="service-card-title"><?php the_title(); ?></h4>
						</a>
					</div>

				</div>

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div>

	</div>

<?php endif; ?>
