<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $posts_per_page
 * @var $layout
 * @var $dots_nav
 * @var $el_class
 * @var $card_bg
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$query = new WP_Query( array(
	'post_type'      => 'testimonial',
	'posts_per_page' => 'all' === strtolower( $posts_per_page ) ? -1 : (int) $posts_per_page,
) );

$carousel_class = 'testimonials-carousel';
$carousel_class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$carousel_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $carousel_class, $this->settings['base'], $atts );

if ( 'cards-2' === $layout ) {
	$carousel_class .= ' testimonials-carousel--columns-2';
}

$card_style = '';
if ( ! empty( $card_bg ) ) {
	$card_style .= 'background-color: ' . $card_bg . ';';
}

$flickity_options = array(
	'cellAlign'   => 'left',
	'wrapAround'  => true,
	'rightToLeft' => is_rtl(),
);

if ( 'hide' === $dots_nav ) {
	$flickity_options['pageDots'] = false;
	$carousel_class .= ' testimonials-carousel--no-dots';
}

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'nur-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Testimonials to show here.', 'nur-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $carousel_class ); ?>">

		<div class="testimonials-carousel-inner" data-flickity="<?php echo esc_attr( wp_json_encode( $flickity_options ) ); ?>">

			<?php while ( $query->have_posts() ) : $query->the_post(); ?>

				<div class="testimonials-carousel-cell">

					<blockquote class="testimonial-card" <?php if ( $card_style ) { echo ' style="' . esc_attr( $card_style ) . '"'; } ?>>
						<div class="testimonial-card-text"><?php the_content(); ?></div>

						<footer class="testimonial-card-author">
							<span class="testimonial-card-author-title"><?php the_title(); ?></span>
							<?php
							$subtitle = get_post_meta( get_the_ID(), '_nur_author_subtitle', true );
							if ( $subtitle ) :
								?>
								<span class="testimonial-card-author-subtitle"><?php echo esc_html( $subtitle ); ?></span>
							<?php endif; ?>
							<div class="testimonial-card-author-avatar"><?php the_post_thumbnail( 'nur_avatar' ); ?></div>
						</footer>
					</blockquote>

				</div>

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div>

	</div>

<?php endif; ?>
