<?php
/**
 * Extensions for WPBakery Visual Composer plugin
 *
 * @package Nur_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'NUR_VC_ADDON_PATH',      NUR_PLUGIN_DIR_PATH . 'visual-composer/' );
define( 'NUR_VC_SHORTCODES_PATH', NUR_PLUGIN_DIR_PATH . 'visual-composer/shortcodes/' );
define( 'NUR_VC_SHORTCODES_URL',  NUR_PLUGIN_DIR_URL . 'visual-composer/shortcodes/' );

/**
 * Register custom VC shortcodes
 */
function nur_vc_map_shortcodes() {
	vc_lean_map( 'nur_image_section',         null, NUR_VC_SHORTCODES_PATH . 'nur_image_section/config.php' );
	vc_lean_map( 'nur_section_heading',       null, NUR_VC_SHORTCODES_PATH . 'nur_section_heading/config.php' );
	vc_lean_map( 'nur_counter_box',           null, NUR_VC_SHORTCODES_PATH . 'nur_counter_box/config.php' );
	vc_lean_map( 'nur_cta_box',               null, NUR_VC_SHORTCODES_PATH . 'nur_cta_box/config.php' );
	vc_lean_map( 'nur_feature_box',           null, NUR_VC_SHORTCODES_PATH . 'nur_feature_box/config.php' );
	vc_lean_map( 'nur_logo_box',              null, NUR_VC_SHORTCODES_PATH . 'nur_logo_box/config.php' );
	vc_lean_map( 'nur_project_preview',       null, NUR_VC_SHORTCODES_PATH . 'nur_project_preview/config.php' );
	vc_lean_map( 'nur_projects_grid',         null, NUR_VC_SHORTCODES_PATH . 'nur_projects_grid/config.php' );
	vc_lean_map( 'nur_recent_posts',          null, NUR_VC_SHORTCODES_PATH . 'nur_recent_posts/config.php' );
	vc_lean_map( 'nur_services_carousel',     null, NUR_VC_SHORTCODES_PATH . 'nur_services_carousel/config.php' );
	vc_lean_map( 'nur_services_grid',         null, NUR_VC_SHORTCODES_PATH . 'nur_services_grid/config.php' );
	vc_lean_map( 'nur_testimonials_carousel', null, NUR_VC_SHORTCODES_PATH . 'nur_testimonials_carousel/config.php' );
}

if ( function_exists( 'vc_lean_map' ) ) {
	// If we can perform the mapping on this stage, then do it.
	nur_vc_map_shortcodes();
} else {
	// Otherwise hook to VC initializiation.
	add_action( 'vc_after_init', 'nur_vc_map_shortcodes' );
}

/**
 * Register image sizes that are used in our custom shortcodes
 */
function nur_vc_register_image_sizes() {
	add_image_size( 'nur_avatar', 90, 90, true );
	add_image_size( 'nur_logo', 133 );
	add_image_size( 'nur_logo_wide', 235 );
	add_image_size( 'nur_small', 480 );
	add_image_size( 'nur_small_square', 480, 480, true );
	add_image_size( 'nur_medium', 740 );
	add_image_size( 'nur_medium_square', 740, 740, true );
	add_image_size( 'nur_large', 1520 );
}
add_action( 'init', 'nur_vc_register_image_sizes' );

/**
 * Add custom JS variables
 */
function nur_vc_admin_js_variables() {
	?>
	<script type="text/javascript">
		var nurVC_l10n = <?php echo wp_json_encode( array( 'project_not_selected' => __( 'Project not selected.', 'nur-plugin' ) ) ); ?>;
	</script>
	<?php
}
add_action( 'admin_head', 'nur_vc_admin_js_variables' );

/**
 * Register Themify icons CSS
 */
function nur_vc_register_themify_icons_style() {
	wp_register_style( 'themify-icons', NUR_PLUGIN_DIR_URL . 'assets/libs/themify-icons/themify-icons.css', false, '1.0.1' );
}
add_action( 'vc_base_register_front_css', 'nur_vc_register_themify_icons_style' );
add_action( 'vc_base_register_admin_css', 'nur_vc_register_themify_icons_style' );

/**
 * Enqueue Themify icons CSS if necessary
 */
function nur_vc_enqueue_themify_icons_style( $font ) {
	if ( 'themify' === $font ) {
		wp_enqueue_style( 'themify-icons' );
	}
}
add_action( 'vc_enqueue_font_icon_element', 'nur_vc_enqueue_themify_icons_style' );

/**
 * Always enqueue Themify icons CSS when inside VC editor mode
 */
function nur_vc_editor_enqueue_themify_icons_style() {
	wp_enqueue_style( 'themify-icons' );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'nur_vc_editor_enqueue_themify_icons_style' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'nur_vc_editor_enqueue_themify_icons_style' );

/**
 * Add Themify icons list to VC icon picker
 */
function nur_vc_iconpicker_type_themify( $icons ) {
	$themify = require NUR_VC_ADDON_PATH . 'vc-themify-icons-config.php';
	return array_merge( $icons, $themify );
}
add_filter( 'vc_iconpicker-type-themify', 'nur_vc_iconpicker_type_themify' );

/**
 * VC Helper functions
 */
require NUR_VC_ADDON_PATH . 'vc-functions.php';
