<?php
/**
 * Helper functions used in our custom shortcodes
 *
 * @package Nur_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Get the list of all terms of the given taxonomy.
 */
function nur_vc_get_taxonomy_terms( $taxonomy, $terms = array() ) {
	// Avoid performing unnecessary calculations by making sure that we are in VC editing mode.
	if ( 'vc_edit_form' !== vc_post_param( 'action' ) ) {
		return $terms;
	}
	$term_objs = get_terms( array( 'taxonomy' => $taxonomy, 'hide_empty' => false ) );
	if ( is_array( $term_objs ) && ! empty( $term_objs ) ) {
		foreach ( $term_objs as $term ) {
			$terms[ $term->name ] = $term->slug;
		}
	}
	return $terms;
}

/**
 * Get the list of terms of the given taxonomy for the given post.
 */
function nur_vc_get_the_terms( $post, $taxonomy ) {
	$terms = get_the_terms( $post, $taxonomy );
	if ( is_wp_error( $terms ) || empty( $terms ) ) {
		return array();
	}
	$term_names = array();
	foreach ( array_values( $terms ) as $term ) {
		$term_names[] = $term->name;
	}
	return $term_names;
}

/**
 * Get the array of the form ( post_name => post_id, ... ) for the given custom post type.
 */
function nur_vc_get_posts_list( $post_type = 'post', $posts = array() ) {
	// Avoid performing unnecessary calculations by making sure that we are in VC editing mode.
	if ( 'vc_edit_form' !== vc_post_param( 'action' ) ) {
		return $posts;
	}
	$post_objs = get_posts( array( 'post_type' => $post_type, 'posts_per_page' => -1 ) );
	foreach ( array_values( $post_objs ) as $post ) {
		$posts[ $post->post_title ] = $post->ID;
	}
	return $posts;
}

/**
 * Checks whether the given media image is 'wide'.
 *
 * We consider an image to be 'wide', when the width is at least 1.5 larger the the height.
 */
function nur_vc_is_image_wide( $image_id ) {
	$image = wp_get_attachment_image_src( $image_id, 'full' );
	if ( ! $image ) {
		return false;
	}
	$width = $image[1];
	$height = $image[2];
	return ( $width > 1.5 * $height );
}

/**
 * AJAX call handler for getting a post title for the given post_id.
 */
function nur_vc_get_post_title() {
	check_ajax_referer( 'vc-nonce-vc-admin-nonce', '_vcnonce' );

	$post_id = intval( $_GET['post_id'] );
	$post_type = isset( $_GET['post_type'] ) ? $_GET['post_type'] : false;
	$post = $post_id ? get_post( $post_id ) : false;

	if ( ! $post || ( $post_type && $post_type !== $post->post_type ) ) {
		wp_send_json_error( __( 'Post not found.', 'nur-plugin' ) );
	}

	wp_send_json_success( $post->post_title );
}
add_action( 'wp_ajax_nur_vc_get_post_title', 'nur_vc_get_post_title' );
