class Preloader {
    constructor() {
        this.preloaderElement = document.querySelector('.preloader');
    }

    show() {
        this.preloaderElement.style.display = 'flex';
        this.preloaderElement.classList.remove('fade-out');
    }

    hide() {
        this.preloaderElement.classList.add('fade-out');
        setTimeout(() => {
            this.preloaderElement.style.display = 'none';
        }, 500);
    }
}

document.addEventListener('DOMContentLoaded', () => {
    const preloader = new Preloader();
    preloader.show();

    window.addEventListener('load', () => {
        preloader.hide();
    });
});