export class serviceSlider {
    constructor() {}
    
    serviceSliderInit() {
        const track = document.querySelector('.slider-track');
        const cards = document.querySelectorAll('.service-card');
        const nextBtn = document.querySelector('.next');
        const prevBtn = document.querySelector('.prev');

        const visibleCards = 4;
        let index = 0;

        const cardWidth = cards[0].offsetWidth + 16; // margin included
        const maxIndex = cards.length - visibleCards;

        const updateButtonStates = () => {
            // Disable prev if at beginning
            if (index === 0) {
                prevBtn.classList.add('disabled');
            } else {
                prevBtn.classList.remove('disabled');
            }

            // Disable next if at end
            if (index === maxIndex) {
                nextBtn.classList.add('disabled');
            } else {
                nextBtn.classList.remove('disabled');
            }
        };

        // Set initial state
        updateButtonStates();

        nextBtn.addEventListener('click', () => {
            if (index < maxIndex) {
                index++;
                track.style.transform = `translateX(-${index * cardWidth}px)`;
                updateButtonStates();
            }
        });

        prevBtn.addEventListener('click', () => {
            if (index > 0) {
                index--;
                track.style.transform = `translateX(-${index * cardWidth}px)`;
                updateButtonStates();
            }
        });
    }
}