export class testimonialSlider {
    constructor() {}
    testimonialSliderInit() {
        const track = document.querySelector('.testimonial-slider-track');
        const items = document.querySelectorAll('.testimonial-item');
        const prevBtn = document.querySelector('.testimonial-slider-control .prev');
        const nextBtn = document.querySelector('.testimonial-slider-control .next');

        let currentIndex = 0;
        const itemHeight = items[0].offsetHeight;
        const totalItems = items.length;

        // Clone first & last for seamless loop
        const firstClone = items[0].cloneNode(true);
        const lastClone = items[totalItems - 1].cloneNode(true);

        track.appendChild(firstClone);
        track.insertBefore(lastClone, items[0]);

        // Start at first real item
        currentIndex = 1;
        track.style.transform = `translateY(-${itemHeight}px)`;

        function slideTo(index) {
            track.style.transition = 'transform 0.4s ease';
            track.style.transform = `translateY(-${index * itemHeight}px)`;
        }

        track.addEventListener('transitionend', () => {
        // Jump instantly (no animation) when hitting clones
        if (currentIndex === 0) {
            track.style.transition = 'none';
            currentIndex = totalItems;
            track.style.transform = `translateY(-${currentIndex * itemHeight}px)`;
        }

        if (currentIndex === totalItems + 1) {
            track.style.transition = 'none';
            currentIndex = 1;
            track.style.transform = `translateY(-${currentIndex * itemHeight}px)`;
        }
        });

        nextBtn.addEventListener('click', () => {
        currentIndex++;
            slideTo(currentIndex);
        });

        prevBtn.addEventListener('click', () => {
            currentIndex--;
            slideTo(currentIndex);
        });


        let autoSlide = setInterval(() => {
            currentIndex++;
            slideTo(currentIndex);
        }, 6000);

        track.addEventListener('mouseenter', () => clearInterval(autoSlide));
        track.addEventListener('mouseleave', () => {
        autoSlide = setInterval(() => {
            currentIndex++;
            slideTo(currentIndex);
        }, 6000);
        });



    }
}