import { headerControl } from '../composables/headerControl.js';

export class globalController {
    constructor() {
        this.settings = {
            siteName: 'Lapomik Energy',
        }; 
    }
    
    init = (self = this) => {
        // Preloader: reuse existing element if present, otherwise create one
        let preloader = document.querySelector('.preloader');
        if (!preloader) {
            preloader = document.createElement('div');
            preloader.classList.add('preloader');
            preloader.innerHTML = `\n                <div class="loader"></div>\n            `;
            document.body.appendChild(preloader);
        }

        const showPreloader = () => {
            preloader.style.display = 'flex';
            preloader.classList.remove('fade-out');
        };

        const hidePreloader = () => {
            preloader.classList.add('fade-out');
            setTimeout(() => {
                preloader.style.display = 'none';
            }, 500);
        };

        // Show then hide after simulated load
        showPreloader();
        setTimeout(() => {
            hidePreloader();
        }, 2000); // Adjust time as needed

        // Initialize header control
        const header = new headerControl();
        header.headerInit();

        // Initialize hamburger menu toggle
        self.menuToggle();
    }

    getSettings() {
        return this.settings;
    }

    // hamburger menu toggle
    menuToggle() {
        const hamburger = document.querySelector(".hamburger-menu");
        const nav = document.querySelector("header nav");

        hamburger.addEventListener("click", () => {
        nav.classList.toggle("open");
        });

    }
}