import { serviceSlider} from '../composables/serviceSlider.js';
import { testimonialSlider } from '../composables/testimonialSlider.js';
export class indexController {
    constructor() {}

    init = (self = this) => {
        // Initialize banner background switcher
        self.bannerBackgroundSwitcher();
        // Initialize service slider
        const slider = new serviceSlider();
        slider.serviceSliderInit();
        // Initialize testimonial slider
        const testimonial = new testimonialSlider();
        testimonial.testimonialSliderInit();
    }

    // banner image video background switcher
    bannerBackgroundSwitcher() {
        const banner = document.querySelector('.banner-section');
        const video = document.querySelector('.banner-video');

        // image duration
        const IMAGE_DURATION = 5000; // 5 seconds
        // is video playing
        let isVideoPlaying = false;

        // show video
        const showVideo = () => {
            if (!isVideoPlaying) {
                banner.classList.add('show-video');
                video.currentTime = 0;
                video.play();
                isVideoPlaying = true;
            }   
        };

        function showImage() {
            banner.classList.remove('show-video');
            isVideoPlaying = false;
        }

        // Start cycle
        setTimeout(showVideo, IMAGE_DURATION);

        // When video finishes → go back to image → repeat
        video.addEventListener('ended', () => {
        showImage();
        setTimeout(showVideo, IMAGE_DURATION);
        });
    }
    
}