import { pageController } from "./controllers/pageController.js";
import { indexController } from "./controllers/indexController.js";
export class Router {
    #pageController = new pageController();
    #currentPage = this.#pageController.getCurrentPage();
    #pages = this.#pageController.getPages();
    #controllers = {
        // Define controllers for different pages
        [this.#pages.home]: () => {
            const indexCtrl = new indexController();
            indexCtrl.init();
        },
    };

    getControllers() {
        return this.#controllers;
    }

    Route = () => {
        let currentPageFile = this.#currentPage.substring(this.#currentPage.lastIndexOf('/') + 1);
        for (const [key, value] of Object.entries(this.#pages)) {
            if (this.#currentPage.includes(value)) {
                const controller = this.#controllers[value];
                if (controller) {
                    controller();
                    break;
                }
            }
        }
    }

}